﻿''' <summary>
''' 此项目中定义的所有异常的基类。所有 CustomerExceptions 均
''' 包含一个 Customer 属性，该属性可用于获取与该异常有关的客户
''' 对象的附加信息。
''' </summary>
''' <remarks></remarks>
Public Class CustomerException
    Inherits CRMSystemException

    Private appSourceValue As String
    Private customerValue As Customer

    Public Sub New(ByVal Message As String, ByVal ReqCustomer As Customer)
        MyBase.New(Message)
        Me.customerValue = ReqCustomer
        Me.appSourceValue = "Tailspin Toys CRM Customer Module"
    End Sub

    ''' <summary>
    ''' 公开有关导致错误的客户对象的附加信息的属性
    ''' </summary>
    Public ReadOnly Property CustomerInfo() As Customer
        Get
            Return customerValue
        End Get
    End Property

    ' 我们希望此级别的异常使用
    ' AppSource，而不是在有人调用
    ' LogError 时会变得重要的父对象。
    ''' <summary>
    ''' 
    ''' </summary>
    Public Overrides ReadOnly Property AppSource() As String
        Get
            Return appSourceValue
        End Get
    End Property
End Class